//
// (c) 2023 wesolutions GmbH
// All rights reserved.
//

import QtQuick 2.12
import QtQuick.Layouts 1.12

import wesual.Ui 1.0
import wesual.Create 1.0

import wesual.data.Core 1.0

ColumnLayout {
    id : dependencyPanel

    property bool supportsContextMenu : true

    property Document document

    signal selectDocument(Document doc)
    signal editDocument(Document doc)
    signal removeDocument(Document doc)

    visible : outgoing.totalCount > 0 || incoming.totalCount > 0

    UiSectionHeader {
        text : qsTrId("47903216424dba5b")
        Layout.bottomMargin : 6
    }

    DependencyView {
        id : outgoing

        document : dependencyPanel.document
        direction : DocumentDependencies.Outgoing

        onSelectDocument : dependencyPanel.selectDocument(doc)
        onEditDocument : dependencyPanel.editDocument(doc)
        onRemoveDocument : dependencyPanel.removeDocument(doc)

        supportsContextMenu : dependencyPanel.supportsContextMenu

        Layout.fillWidth : true
    }

    DependencyView {
        id : incoming

        document : dependencyPanel.document
        direction : DocumentDependencies.Incoming

        onSelectDocument : dependencyPanel.selectDocument(doc)
        onEditDocument : dependencyPanel.editDocument(doc)
        onRemoveDocument : dependencyPanel.removeDocument(doc)

        supportsContextMenu : dependencyPanel.supportsContextMenu

        Layout.fillWidth : true
    }
}
